﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Security;
using System.IO;
using System.Threading;

namespace Chapter_39
{
    class Program
    {
        static void Main(string[] args)
        {
            //QuickStartProcesses();
            //DiggingIntoProcesses();
            //HandlingProcessStreams();
            //GetProcessList();
            //GetProcessInfo();
            //FindFirefoxProcess();
            //KillFirefoxProcesses();
            //StartThread();
            //StartParameterizedThread();
            //ThreadStartWithLambda();
            //StartThreadQueue();
            //LockThreads();
            //MonitorThreads();
            //MontitorThreadsWithTimeout();
            //MonitorWaitAndPulse();
            ReaderThread();
            WriterThread();

            Console.ReadKey();
        }

        private static void QuickStartProcesses()
        {
            // simple process start
            //Process.Start("calc");

            // starting a process with arguments
            //Process.Start("devenv", "..\\..\\Program.cs");

            // starting a process with credentials
            var secPwd = new SecureString();

            "hasło"
                .ToCharArray()
                .Cast<char>()
                .ToList()
                .ForEach
                (
                    ch => secPwd.AppendChar(ch)
                );

            Process.Start(
                @"C:\Program Files\Microsoft Visual Studio 9.0\Common7\IDE\devenv.exe",
                "NazwaUżytkownika",
                secPwd,
                "KomputerLubDomena");
        }

        private static void DiggingIntoProcesses()
        {
            var startInfo = new ProcessStartInfo();
            startInfo.FileName = "devenv";
            startInfo.Arguments = "Program.cs";
            startInfo.WorkingDirectory = @"..\..";
            startInfo.WindowStyle = ProcessWindowStyle.Maximized;
            startInfo.ErrorDialog = true;
            
            var proc = new Process();
            proc.StartInfo = startInfo;
            proc.Start();
        }

        private static void HandlingProcessStreams()
        {
            var startInfo = new ProcessStartInfo();
            startInfo.FileName = "osql";
            startInfo.Arguments = "-E -dNorthwind -Q\"select top 10 * from customers\"";
            startInfo.RedirectStandardOutput = true;
            startInfo.UseShellExecute = false;
            var proc = new Process();
            proc.StartInfo = startInfo;
            
            proc.Start();

            using (StreamReader rdr = proc.StandardOutput)
            {
                Console.WriteLine("--- początek wyjścia ---");
                Console.WriteLine(rdr.ReadToEnd());
                Console.WriteLine("--- koniec wyjścia ---");
            }
        }

        private static void GetProcessList()
        {
            Process.GetProcesses()
                .ToList()
                .ForEach(
                    proc => Console.WriteLine(proc.ProcessName));
        }

        private static void GetProcessInfo()
        {
            Process.GetProcesses()
                .ToList()
                .ForEach(
                    proc => 
                        {
                            Console.WriteLine(
                                "Nazwa: {0}, ID: {1}, Pamięć: {2}",
                                proc.ProcessName,
                                proc.Id,
                                proc.WorkingSet64);
                        });
        }

        private static void FindFirefoxProcess()
        {
            var fireFoxProc =
                from proc in Process.GetProcesses()
                where proc.ProcessName == "firefox"
                select proc;
        }

        private static void KillFirefoxProcesses()
        {
            (from proc in Process.GetProcesses()
             where proc.ProcessName == "firefox"
             select proc)
             .ToList()
             .ForEach(ff => ff.Kill());
        }

        private static void StartThread()
        {
            var th = new Thread(new ThreadStart(SayHello));

            th.Start();
        }

        public static void SayHello()
        {
            Console.WriteLine("Witaj - tu pojedynczy wątek.");
        }

        private static void StartParameterizedThread()
        {
            var th = new Thread(new ParameterizedThreadStart(SayHello));

            th.Start("Jan");
        }

        public static void SayHello(object name)
        {
            Console.WriteLine(
                "Witaj {0} - pozdrawia Cię wątek parametryczny.",
                name as string);
        }

        private static void ThreadStartWithLambda()
        {
            new Thread(
                () => Console.WriteLine(
                    "Hello from a single thread via Lambda."))
            .Start();
        }

        private static void StartThreadQueue()
        {
            ThreadPool.QueueUserWorkItem(new WaitCallback(SayHello), "Jan");
            
            ThreadPool.QueueUserWorkItem(
                stateInfo => 
                    {
                        int minWorker;
                        int maxWorker;
                        int minIOCompletionPort;
                        int maxIOCompletionPort;

                        ThreadPool.GetMinThreads(out minWorker, out minIOCompletionPort);
                        ThreadPool.GetMaxThreads(out maxWorker, out maxIOCompletionPort); 
                        
                        Console.WriteLine(
                            "Liczba wątków działających - Min: {0} Max: {1}\n" +
                            "Liczba wątków zakończonych - Min: {2} Max: {3}",
                            minWorker, 
                            maxWorker,
                            minIOCompletionPort,
                            maxIOCompletionPort);
                    });

        }

        private static object m_erPatientsLock = new object();
        private static List<string> m_erPatients = new List<string>();

        private static void LockThreads()
        {
            lock (m_erPatientsLock)
            {
                m_erPatients.Add("Jan Kowalski");
            }
        }

        private static void MonitorThreads()
        {
            try
            {
                Monitor.Enter(m_erPatientsLock);

                m_erPatients.Add("Jan Kowalski");
            }
            finally
            {
                Monitor.Exit(m_erPatientsLock);
            }
        }

        private static void MontitorThreadsWithTimeout()
        {
            try
            {
                if (!Monitor.TryEnter(m_erPatientsLock, 300))
                {
                    return;
                }

                m_erPatients.Add("Jan Kowalski");
            }
            finally
            {
                Monitor.Exit(m_erPatientsLock);
            }
        }

        private static ReaderWriterLockSlim m_erPatientsRWLock = new ReaderWriterLockSlim();

        private static void ReaderThread()
        {
            try
            {
                m_erPatientsRWLock.EnterReadLock();

                int count = m_erPatients.Count;
            }
            finally
            {
                m_erPatientsRWLock.ExitReadLock();
            }
        }

        private static void WriterThread()
        {
            try
            {
                m_erPatientsRWLock.EnterWriteLock();

                m_erPatients.Add("Jan Kowalski");
            }
            finally
            {
                m_erPatientsRWLock.ExitWriteLock();
            }
        }
    }
}
